//******************************************
// file 		: SQ7653_TMRA0.c
// version		: V 1.00 2019/12/18
// brief		: TMRA0 related functions
// note			:
//******************************************

#include "main.h"


//*********************************************************************
// name			: TMRA00_Timer_Init
// brief		: TMRA00 initialization to 8-bit timer mode
// note			:
//*********************************************************************
void TMRA00_Timer_Init(void)
{
//====== enable function ======
    PCKEN0_TMRA0 = 1;                   // this must be enabled first, the relevant staging settings later to be useful
   	
//====== parameter setting ======
    TMRA0CFG_TCFG   = set_8bit;         // set to 8-bit mode
    TMRA0MD0_TCM    = timer;            // set to 8-bit timer mode
    TMRA0MD0_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA0MD0_DBE    = 1;                // enable double buffer
    
    TMRA0DR0        = 100;              // set timer count value to 100 (every interrupt is generated every 100*0.167 = 16.7us)
}

//*********************************************************************
// name			: TMRA00_PPG_Init
// brief		: TMRA00 initialization to 8-bit PPG mode
// note			:
//*********************************************************************
void TMRA00_PPG_Init(void)
{
//====== pin configuration initialization ======
    P0DO_P5         = 1;                // set P0.5 output level as the same as TMRA0MD0_TFF
    P0OE_P5         = 1;                // set P0.5 as output pin

//====== enable function ======
    PCKEN0_TMRA0    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_8bit;         // set to 8-bit mode
    TMRA0MD0_TCM    = PPG;              // set to 8-bit PPG mode
	
    TMRA0MD0_TFF    = 1;                // set output pin inital state to high level
//	***it is recommended to set PxCFGCR after the function initial value is set
    P0CFGCR         = 0xD1;             // // set PPG output pin to P0.5
    
    TMRA0MD0_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA0MD0_DBE    = 1;                // enable double buffer

    TMRA0DR0        = 100;              // set PPG period to 16.7us (0.167*100)
    TMRA0PWM0       = 50;               // set PPG duty cycle = 50/100 = 50%
}

//*********************************************************************
// name			: TMRA00_PWM_Init
// brief		: TMRA00 initialization to 8-bit PWM mode
// note			:
//*********************************************************************
void TMRA00_PWM_Init(void)
{
//====== pin configuration initialization ======
    P0DO_P5         = 1;                // set P0.5 output level as the same as TMRA0MD0_TFF
    P0OE_P5         = 1;                // set P0.5 as output pin

//====== enable function ======
    PCKEN0_TMRA0    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_8bit;         // set to 8-bit mode
    TMRA0MD0_TCM    = PWM;              // set to 8-bit PWM mode
	
    TMRA0MD0_TFF    = 1;                // set output pin inital state to high level	
//	***it is recommended to set PxCFGCR after the function initial value is set
    P0CFGCR         = 0xD1;             // // set PWM output pin to P0.5

    TMRA0MD0_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA0MD0_DBE    = 1;                // enable double buffer

// period : 128 * 0.167us = 21.376us
    TMRA0PWM0       = 128;              // (128/2)/128 = 50%
	

}


//*********************************************************************
// name			: TMRA00_ECounter_Init
// brief		: TMRA00 initialization to 8-bit event counter mode
// note			:
//*********************************************************************
void TMRA00_ECounter_Init(void)
{
//==== enable function ======
    PCKEN0_TMRA0 = 1;                   // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_8bit;         // set to 8-bit mode
    TMRA0MD0_TCM    = event_counter;    // set to 8-bit event counter mode
    TMRA0MD0_DBE    = 1;                // enable double buffer
	TMRA0DR0        = 250;              // set counter value

	P0CFGCR         = 0xD1;             // set event counter pin to P0.5
    
}

//*********************************************************************
// name			: TMRA0_12BIT_PWM_Init
// brief		: TMRA00 initialization to 12-bit PWM mode
// note			:
//*********************************************************************
void TMRA0_12BIT_PWM_Init(void)
{
//====== pin configuration initialization ======
    P0DO_P4         = 1;                // set P0.4 output level as the same as TMRA0MD1_TFF
    P0OE_P4         = 1;                // set P0.4 as output pin

//====== enable function ======
    PCKEN0_TMRA0    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_16bit;        // set to 16-bit mode
    TMRA0MD1_TCM    = PWM;                // set to 12-bit PWM mode

    TMRA0MD1_TFF    = 1;                // set output pin inital state to high level
   
    TMRA0MD1_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA0MD1_DBE    = 1;                // enable double buffer
	
	TMRA0PWM0       = 0xAA; 
    TMRA0PWM1       = 0xA;              // duty cycle = 0xAAA/16/256 = 170.625/256 = 66.7%
	//	***it is recommended to set PxCFGCR after the function initial value is set
	P0CFGCR         = 0xC1;             // set PWM output pin to P0.4
}


//*********************************************************************
// name			: TMRA0_16BIT_ECounter_Init
// brief		: TMRA0 initialization to 16-bit event counter mode
// note			:
//*********************************************************************
void TMRA0_16BIT_ECounter_Init(void)
{
//==== enable function ======
    PCKEN0_TMRA0 = 1;                   // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_16bit;        // set to 16-bit mode
    TMRA0MD1_TCM    = event_counter;    // set to 16-bit event counter mode
   	
	TMRA0MD1_DBE    = 1;                // enable double buffer
	TMRA0DR0        = 100;              // set counter value
    TMRA0DR1        = 2;                // set counter value
	P0CFGCR         = 0xD1;             // set event counter pin to P0.5
    
}

//*********************************************************************
// name			: TMRA0_16BIT_PPG_Init
// brief		: TMRA0 initialization to 16-bit PPG mode
// note			:
//*********************************************************************
void TMRA0_16BIT_PPG_Init(void)
{
//====== pin configuration initialization ======
    P0DO_P4         = 1;                // set P0.4 output level as the same as TMRA0MD1_TFF
    P0OE_P4         = 1;                // set P0.4 as output pin

//====== enable function ======
    PCKEN0_TMRA0    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = set_16bit;        // set to 16-bit mode
    TMRA0MD1_TCM    = PPG;              // set to 16-bit PPG mode
	
    TMRA0MD1_TFF    = 1;                // set output pin inital state to high level
//	***it is recommended to set PxCFGCR after the function initial value is set
    P0CFGCR         = 0xC1;             // set PPG output pin to P0.4
    
    TMRA0MD1_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA0MD1_DBE    = 1;                // enable double buffer

    TMRA0DR0        = 50;           	// set PPG period =(100*256+50)=25650
    TMRA0DR1        = 100;
	
	TMRA0PWM0       = 40;               // set PPG duty cycle =(80*256+40)=20520, 20520/25650=80%
    TMRA0PWM1       = 80;             
}

//*********************************************************************
// name			: TMRA0_Prescale_PPG_Init
// brief		: TMRA0 initialization to PPG with prescale mode
// note			: 
//*********************************************************************
void TMRA0_Prescale_PPG_Init(void)
{
	//====== pin configuration initialization ======
    P0DO_P4         = 1;                // set P0.4 output level as the same as TMRA0MD1_TFF
    P0OE_P4         = 1;                // set P0.4 as output pin

//====== enable function ======
    PCKEN0_TMRA0    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA0CFG_TCFG   = pre_scale;        // set to prescale mode
	TMRA0MD0_TCM    = PPG;              // set to PPG mode
    TMRA0MD1_TCM    = PPG;              // set to PPG mode
	
	TMRA0MD0_TFF    = 1;                // set initial state to high level in prescale module
    TMRA0MD1_TFF    = 1;                // set initial state to high level in PPG module
    
    TMRA0MD0_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
	TMRA0MD0_DBE    = 1;                // enable double buffer
    TMRA0MD1_DBE    = 1;                // enable double buffer

    TMRA0PWM0       = 5;                // set duty cycle = (5/10)= 50%
    TMRA0DR0        = 10;           	 
    
	TMRA0PWM1       = 80;               // set PPG duty cycle 80/100 = 80% 
	TMRA0DR1        = 100;
	//	***it is recommended to set PxCFGCR after the function initial value is set
    P0CFGCR         = 0xC1;             // set PPG output pin to P0.4
	//P0CFGCR         = 0xD1;             // set prescale output pin to P0.5
}

//*********************************************************************
// name			: TMRA00_SetDuty
// brief		: set duty cycle
// note			: 
//*********************************************************************
void TMRA00_SetDuty(uchar duty)
{
    TMRA0PWM0      = duty;
}

//*********************************************************************
// name			: TMRA00_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TMRA00_SetPeriod(uchar period)
{
    TMRA0DR0       = period;
}

//*********************************************************************
// name			: TMRA01_SetDuty
// brief		: set duty cycle
// note			: 
//*********************************************************************
void TMRA01_SetDuty(uchar duty)
{
    TMRA0PWM1     = duty;
}

//*********************************************************************
// name			: TMRA01_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TMRA01_SetPeriod(uchar period)
{
    TMRA0DR1      = period;
}


//*********************************************************************
// name			: TMRA0_16BIT_SetDuty
// brief		: set duty cycle
// note			:                
//*********************************************************************
void TMRA0_16BIT_SetDuty(uint duty)
{    
	TMRA0PWM0     = (duty & 0xFF);
	TMRA0PWM1     = ((duty & 0xFF00)>>8);
}

//*********************************************************************
// name			: TMRA00_16BIT_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TMRA0_16BIT_SetPeriod(uint period)
{
    TMRA0DR0     = (period & 0xFF);
	TMRA0DR1     = ((period & 0xFF00)>>8);
}

//*********************************************************************
// name			: TMRA0_SetPrescale
// brief		: set period
// note			: 
//*********************************************************************
void TMRA0_SetPrescale(uchar duty)
{   
   	TMRA0PWM0    = duty;                // set duty cycle of prescale
  	if((duty*2)>255)                    // set cycle time of prescale
		TMRA0DR0 = 255;
	else
		TMRA0DR0 = (duty*2);
}

//*********************************************************************
// name			: TMRA00_Start
// brief		: start to run TMRA00
// note			:
//*********************************************************************
void TMRA00_Start(void)
{
    TMRA0CR0_RUN   = 1;                
}

//*********************************************************************
// name			: TMRA01_Start
// brief		: start to run TMRA01 or start to run TMRA0
// note			:
//*********************************************************************
void TMRA01_Start(void)
{
    TMRA0CR1_RUN   = 1;                
}

//*********************************************************************
// name			:TMRA00_Stop
// brief		: stop TMRA00
// note			:
//*********************************************************************
void TMRA00_Stop(void)
{
    TMRA0CR0_RUN   = 0;                
}

//*********************************************************************
// name			:TMRA01_Stop
// brief		: stop TMRA01 or stop TMRA0
// note			:
//*********************************************************************
void TMRA01_Stop(void)
{
    TMRA0CR1_RUN   = 0;                
}
//*********************************************************************
// name			: TMRA00_IntEnable
// brief		: enable TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntEnable(void)
{
    DI;                                 // enable all maskable interrupts // EIRL_IMF=0
    IFR_TMRA00_IRQ = 0;                 // clear TMRA00 interrupt flag
    IER_TMRA00_IRQ = 1;                 // enable TMRA00 interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: TMRA01_IntEnable
// brief		: enable TMRA01 interrupt or enable TMRA0 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntEnable(void)
{
    DI;                                 // enable all maskable interrupts // EIRL_IMF=0
    IFR_TMRA01_IRQ = 0;                 // clear TMRA01 interrupt flag
    IER_TMRA01_IRQ = 1;                 // enable TMRA01 interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: TMRA00_IntDisable
// brief		: disable TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntDisable(void)
{
    DI;                                 // enable all maskable interrupts // EIRL_IMF=0
    IER_TMRA00_IRQ = 0;                 // disable TMRA00 interrupt
	IFR_TMRA00_IRQ = 0;                 // clear TMRA00 interrupt flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: TMRA01_IntDisable
// brief		: disable TMRA01 interrupt or disable TMRA0 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntDisable(void)
{
    DI;                                 // enable all maskable interrupts // EIRL_IMF=0
    IER_TMRA01_IRQ = 0;                 // disable TMRA01 interrupt
	IFR_TMRA01_IRQ = 0;                 // clear TMRA01 interrupt flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: TMRA00_IRQ
// brief		: TMRA00 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA00_IRQ(void)
{
	LED1_out = ~ LED1_out;              // invert LED1
    NOP;                                // no operation
}

//*********************************************************************
// name			: TMRA01_IRQ
// brief		: TMRA01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA01_IRQ(void)
{ 
	LED1_out = ~ LED1_out;              // invert LED1
    NOP;                                // no operation
}


//*********************************************************************
// name			: TMRA10_PPG_Init
// brief		: TMRA10 initialization to 8-bit PPG mode
// note			:
//*********************************************************************
void TMRA10_PPG_Init(void)
{
//====== pin configuration initialization ======
    P0DO_P3         = 1;                // set P0.3 output level as the same as TMRA1MD0_TFF
    P0OE_P3         = 1;                // set P0.3 as output pin

//====== enable function ======
    PCKEN0_TMRA1    = 1;                // this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
    TMRA1CFG_TCFG   = set_8bit;         // set to 8-bit mode
    TMRA1MD0_TCM    = PPG;              // set to 8-bit PPG mode
	
    TMRA1MD0_TFF    = 1;                // set output pin inital state to high level
//	***it is recommended to set PxCFGCR after the function initial value is set
    P0CFGCR         = 0xB1;             // set PPG output pin to P0.3
    
    TMRA1MD0_TCK    = 5;                // fcgck/4 = 6MHz = 0.167us
    TMRA1MD0_DBE    = 1;                // enable double buffer

    TMRA1DR0        = 100;              // set PPG period = 100*0.167us =16.7us(PPG=TMRA1DR0*TMRA1MD0_TCK)
    TMRA1PWM0       = 50;               // set PPG duty cycle = 50/100 = 50%
}

//*********************************************************************
// name			: TMRA10_Start
// brief		: start TMRA10
// note			:
//*********************************************************************
void TMRA10_Start(void)
{
    TMRA1CR0_RUN   = 1;                
}

//*********************************************************************
// name			: TMRA10_Stop
// brief		: stop TMRA10
// note			:
//*********************************************************************
void TMRA10_Stop(void)
{
    TMRA1CR0_RUN   = 0;                
}